# bark_beetle_experiment_ttest.R
# Two-sample t test for bark beetle trapping experiment
# Load necessary libraries
library(ggplot2)

# Read in data set
bbdata <- read.table(header=T,colClasses=c("factor","numeric"),text="
treat count
A   373
A   126
A   255
A   138
A   379
B    25
B    64
B    62
B    71
B    54                     
")

# Apply transformations here
bbdata <- transform(bbdata,y=log10(count))

# Print data
bbdata

# Graphics using ggplot2
ggplot(bbdata,aes(treat,y))+
geom_jitter(size=2,position=position_jitter(width=0.1))+
stat_summary(fun="mean",geom="point",size=3)+
stat_summary(fun.data="mean_cl_normal",geom="errorbar",width=0.2,linewidth=1)

# Two-sample t test
t.test(y~treat,bbdata,var.equal=TRUE)

